<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/config.php';

$conn = new mysqli(HOST, USERNAME, PASSWORD, DBNAME);
if ($conn->connect_error) {
    die("❌ خطا در اتصال به دیتابیس: " . $conn->connect_error);
}

function sendTelegramLog($text) {
    $chat_id = $GLOBALS['sendchnl']; // کانال یا ادمین
    $token = TOKEN;
    $url = "https://api.telegram.org/bot$token/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',  // اینجا HTML شد
    ];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $result = curl_exec($ch);
    curl_close($ch);
}

function baseUrl($url) {
    $parts = parse_url($url);
    $base = $parts['scheme'] . '://' . $parts['host'];
    if (isset($parts['port'])) $base .= ':' . $parts['port'];
    if (isset($parts['path']) && trim($parts['path'], '/') !== '') $base .= '/' . trim($parts['path'], '/');
    return $base;
}

function curlRequest($url, $method = 'GET', $headers = [], $cookie = '', $postFields = null) {
    $curl = curl_init($url);
    $defaultHeaders = [
        "Accept: application/json, text/plain, */*",
        "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)",
        "X-Requested-With: XMLHttpRequest"
    ];
    if (!empty($cookie)) {
        $defaultHeaders[] = "Cookie: x-ui=$cookie";
    }
    $allHeaders = array_merge($defaultHeaders, $headers);

    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HEADER, true);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $allHeaders);
    curl_setopt($curl, CURLOPT_TIMEOUT, 15);
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
    if ($method === 'POST' && !is_null($postFields)) {
        curl_setopt($curl, CURLOPT_POSTFIELDS, is_array($postFields) ? http_build_query($postFields) : $postFields);
    }

    $response = curl_exec($curl);
    $err = curl_error($curl);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);

    $header = substr($response, 0, $header_size);
    $body = substr($response, $header_size);

    curl_close($curl);

    return [
        'response' => $body,
        'headers_raw' => $header,
        'error' => $err,
        'http_code' => $http_code,
    ];
}

$result = $conn->query("SELECT * FROM server_info");
if (!$result) die("❌ خطا در واکشی اطلاعات: " . $conn->error);

$index = 1;
while ($row = $result->fetch_assoc()) {
    $server_id = $row['id'];
    $panel_url = baseUrl($row['panel_url']);
    $cookie_val = trim($row['cookie']); // فقط مقدار کوکی، بدون x-ui=
    $auth_parts = explode(':', $row['auth'], 2);
    $username = $auth_parts[0] ?? '';
    $password = $auth_parts[1] ?? '';

    echo "\n==============================\n";
    echo "[$index] ⏳ بررسی سرور: $panel_url\n";

    $res = curlRequest("$panel_url/xui/API/inbounds/", 'GET', [], $cookie_val);

    if ($res['http_code'] === 401) {
        echo "[$index] 🔄 لاگین مجدد... استفاده از یوزرنیم: $username\n";

        $loginUrl = "$panel_url/login";
        $loginHeaders = ["Content-Type: application/x-www-form-urlencoded"];
        $loginData = ["username" => $username, "password" => $password];

        $loginRes = curlRequest($loginUrl, 'POST', $loginHeaders, '', $loginData);

        echo "[$index] 📝 بدنه پاسخ لاگین: " . $loginRes['response'] . "\n";

        $loginJson = json_decode($loginRes['response'], true);
        if (!$loginJson || empty($loginJson['success']) || $loginJson['success'] !== true) {
            echo "[$index] ❌ لاگین ناموفق\n";
            $index++;
            continue;
        }

        $new_cookie = '';
        if (preg_match('/Set-Cookie:\s*x-ui=([^;]+)/i', $loginRes['headers_raw'], $m)) {
            $new_cookie = trim($m[1]);
        }

        if (empty($new_cookie)) {
            echo "[$index] ❌ کوکی لاگین یافت نشد\n";
            $index++;
            continue;
        }

        // ذخیره فقط مقدار کوکی، نه با x-ui=
        $conn->query("UPDATE server_info SET cookie='$new_cookie' WHERE id=$server_id");
        echo "[$index] 🔄 کوکی لاگین ذخیره شد: $new_cookie\n";

        // استفاده از کوکی جدید برای درخواست بعدی
        $cookie_val = $new_cookie;
        $res = curlRequest("$panel_url/xui/API/inbounds/", 'GET', [], $cookie_val);
    }

    if ($res['http_code'] !== 200) {
        echo "[$index] ❌ کد {$res['http_code']} در دریافت Inbounds\n";
        $index++;
        continue;
    }

    $json = json_decode($res['response'], true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo "[$index] ⚠️ خطا در تجزیه JSON: " . json_last_error_msg() . "\n";
        $index++;
        continue;
    }

    if (!isset($json['success']) || $json['success'] !== true) {
        echo "[$index] ⚠️ پاسخ JSON نامعتبر یا ناموفق\n";
        $index++;
        continue;
    }

    $depleted_found = false;
    $depleted_clients_info = [];

    foreach ($json['obj'] as $inbound) {
        foreach ($inbound['clientStats'] ?? [] as $client) {
            $up = floatval($client['up']);
            $down = floatval($client['down']);
            $used = $up + $down;
            $used_gb = $used / (1024 ** 3);
            $total = floatval($client['total']);
            $total_gb = $total / (1024 ** 3);

            if ($total > 0 && $used >= $total) {
                $depleted_found = true;
                $depleted_clients_info[] = [
                    'email' => $client['email'],
                    'used_gb' => round($used_gb, 2),
                    'allowed_gb' => round($total_gb, 2),
                ];
            }
        }
    }

    if ($depleted_found) {
        foreach ($depleted_clients_info as $cli) {
            // لاگ زیبا با قالب HTML
            $msg = "🚫 <b>سرویس حذف شد</b>\n"
                  . "🧑‍💻 <b>کاربر:</b> <code>{$cli['email']}</code>\n"
                  . "📍 <b>پنل:</b> <code>$panel_url</code>\n"
                  . "📊 <b>حجم مصرفی:</b> <b>{$cli['used_gb']} گیگ / {$cli['allowed_gb']} گیگ</b>\n"
                  . "🕒 <b>زمان حذف:</b> <code>" . date("Y-m-d H:i") . "</code>";

            echo "[$index] 📤 ارسال پیام تلگرام: $msg\n";
            sendTelegramLog($msg);
        }

        $del_url = "$panel_url/xui/API/inbounds/delDepletedClients/-1";
        $del_headers = [
            "Content-Type: application/x-www-form-urlencoded; charset=UTF-8",
            "Origin: $panel_url",
            "Referer: $panel_url/xui/",
            "Cookie: x-ui=$cookie_val",
        ];

        $del_res = curlRequest($del_url, 'POST', $del_headers, $cookie_val);

        if ($del_res['http_code'] === 200) {
            echo "[$index] ✅ کاربران حذف شدند.\n";
        } else {
            echo "[$index] ❌ حذف کاربران ناموفق (کد {$del_res['http_code']})\n";
        }
    } else {
        echo "[$index] ✅ هیچ کاربری حجمش تمام نشده در سرور $panel_url\n";
    }

    $index++;
}

$conn->close();
