<?php
include_once __DIR__.'/config.php';
include_once __DIR__.'/telegram.php';
$telegram = new telegram(TOKEN,HOST,USERNAME,PASSWORD,DBNAME); 
$time = time();

$table_exists = $telegram->db->query("show tables like 'config_stat';")->rowCount();
if(!$table_exists){
	$sql = "CREATE TABLE `config_stat` (`id` INT NOT NULL AUTO_INCREMENT , `userid` VARCHAR(50) NOT NULL , `remark` VARCHAR(100) NOT NULL , `total` VARCHAR(20) NOT NULL , `up` VARCHAR(20) NOT NULL , `down` VARCHAR(20) NOT NULL , `expiryTime` VARCHAR(40) NOT NULL , PRIMARY KEY (`id`)) ENGINE = MyISAM;";
	$telegram->db->query($sql);
}
$table_exists = $telegram->db->query("show tables like 'clog';")->rowCount();
if(!$table_exists){
	$telegram->db->query("CREATE TABLE `clog` (`id` INT NOT NULL AUTO_INCREMENT , `remark` VARCHAR(100) NOT NULL , `userid` VARCHAR(30) NOT NULL , `type` VARCHAR(50) NOT NULL , `date` VARCHAR(30) NOT NULL , PRIMARY KEY (`id`)) ENGINE = MyISAM;");
}

$cron = file_get_contents(__DIR__.'/notifm.txt');
if($cron == ''){
	file_put_contents(__DIR__.'/notifm.txt', 0);
	$cron = 0;
}

if(is_null($delete_delay)) $delete_delay = 3;
if(is_null($gb_notif_limit)) $gb_notif_limit = 2;
if(is_null($day_notif_limit)) $day_notif_limit = 2;

$orders = $telegram->db->query("select *, fl_order.id as order_id, fl_order.userid as user_id from fl_order inner join server_info where fl_order.server_id = server_info.id and server_info.ptype = 'marzban' and fl_order.id > $cron and fl_order.status=1 and fl_order.notif=0 ORDER BY fl_order.id LIMIT 50; ");
if($orders){
    $orders = $orders->fetchAll(2);
    if(!empty($orders)){
    foreach ($orders as $order) { 
        $send = false;
	    $userid = $order['user_id'];
        $username = $order['remark'];
        $server_id = $order['server_id'];
        $inbound_id = $order['inbound_id'];
        $amount = $order['amount'];
        $notif = $order['notif'];
		$oid = $order['order_id'];
		
		file_put_contents(__DIR__.'/notifm.txt', $oid);
		
        $rowCount = $telegram->db->query("select * from server_info where id=$server_id")->rowCount();
        if($rowCount == 0) continue;
		
        include_once('marz.php');
        $response = muser_detail($server_id, $username); 
        if(is_null($response) or !$response) continue;
    
    	if(!$response->subscription_url) continue;
       
        $expiryTime = $response->expire;
        if(preg_match('/-/', $expiryTime)) $expiryTime = strtotime($expiryTime);
        $total = $response->data_limit;
        $used_traffic = $response->used_traffic;
		
		if(is_null($expiryTime) or is_null($total) or $total == 0 or $total < 0 or $expiryTime == 0 or $expiryTime < 0)
			continue;
		
		
		$leftgb = round( ($total - $used_traffic) / 1073741824, 2);
		
		$exists = $telegram->db->query("select * from config_stat where remark = '$username'")->rowCount();
		if($exists)
			$telegram->db->query("update config_stat set total='$total',up='$used_traffic',down='$used_traffic',expiryTime='$expiryTime' where remark = '$username'");
		else
			$telegram->db->query("insert into config_stat VALUES (NULL, '$userid', '$username', '$total', '$used_traffic', '$used_traffic', '$expiryTime')");
		
		
		if(is_numeric($expiryTime) and is_numeric($leftgb)){
			if($expiryTime < time() + (86400 * $day_notif_limit) ) $send = "روز"; elseif($leftgb < $gb_notif_limit) $send = "گیگ";
		}
        
        if($send){
			
			$notif_limit = ($send =='روز') ? $day_notif_limit : $gb_notif_limit;
			if($send =='روز'){
				$msg = "از سرویس اشتراک $username کمتر از ($notif_limit $send) باقی مانده است. می توانید از قسمت سرویس های من با انتخاب گزینه تمدید سرویس، سرویس خود را تمدید کنید. در صورت عدم تمدید تا $delete_delay روز آینده، سرویس شما حذف خواهد شد.";
			}else{
				$msg = "💡 کاربر گرامی،
از سرویس اشتراک $username کمتر از ($notif_limit $send) باقی مانده است. می توانید از قسمت سرویس های من با انتخاب گزینه افزایش حجم، ترافیک اضافه تهیه کنید یا سرویس خود را تمدید کنید.";
			}
            
			//$telegram->sendMessage($sendchnl, $msg);
            $aa = $telegram->sendMessage($userid, $msg); //file_put_contents('1221.txt', $userid.json_encode($aa));
            if($userid == '1986149871') $telegram->sendMessage($sendnotif, $msg);
            $telegram->db->query("update `fl_order` set notif= $time + 86400*$delete_delay where remark='$username'");
        }
		file_put_contents(__DIR__.'/notifm.txt', $oid);
    }
  } else file_put_contents(__DIR__.'/notifm.txt', 0);
}

echo "ok";
